package gov.va.vamf.scheduling.varutility.domain;


import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(namespace = Namespace.VarUtility)
public class CustomRequestSetting extends CoreSetting {

    @XmlElement
    private Boolean supported;

    @XmlElement
    private SchedulingDays schedulingDays;

    public CustomRequestSetting() {}

    public CustomRequestSetting(String id, String typeOfCare, Boolean supported, SchedulingDays schedulingDays, Integer submittedRequestLimit, Integer enterpriseSubmittedRequestLimit) {
        this.setId(id);
        this.setTypeOfCare(typeOfCare);
        this.supported = supported;
        this.schedulingDays = schedulingDays;
        this.setSubmittedRequestLimit(submittedRequestLimit);
        this.setEnterpriseSubmittedRequestLimit(enterpriseSubmittedRequestLimit);
    }

    public Boolean getSupported() {
        return supported;
    }

    public void setSupported(Boolean supported) {
        this.supported = supported;
    }

    public SchedulingDays getSchedulingDays() {
        return schedulingDays;
    }

    public void setSchedulingDays(SchedulingDays schedulingDays) {
        this.schedulingDays = schedulingDays;
    }

}
